/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.List;

public class AttLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLATT";
    private static final String TRACE_MASKF = "XRCSLATF";
    private static final String TRACE_MASKD = "XRCSLATD";
    private static AttLink instance;

    protected AttLink() {
        this.maxOpenPaths = 1;
        Trace.trace(TRACE_MASKT, "<-> AttLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new AttLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        block9: {
            Trace.trace(TRACE_MASKT, "--> activate()");
            if (this.active) {
                throw new LinkAlreadyActiveException();
            }
            if (!this.isConfigured()) {
                throw new LinkNotConfiguredException();
            }
            try {
                int rc = 0;
                OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
                ModemConfigData modemConfig = ModemConfigManager.getModemConfigManager().getModemConfig();
                List phoneInfo = outConfig.getPhoneInfo();
                rc = RcsControl.queryModem();
                if (rc == 0) {
                    throw new LinkFailedException("Failed to detect a modem (RC:" + rc + ")");
                }
                boolean connected = false;
                Iterator i = phoneInfo.iterator();
                while (i.hasNext()) {
                    PhoneInfo pInfo = (PhoneInfo)i.next();
                    String number = modemConfig.getDialPrefix() + pInfo.getDialString();
                    RcsConfig.getRcsConfig().setTemporaryConfigValue("modem_dial_number", number);
                    rc = RcsControl.startDial();
                    if (rc != 0) continue;
                    connected = true;
                    break;
                }
                if (!connected) {
                    throw new LinkFailedException("Failed to dial (RC: " + rc + ")");
                }
                rc = RcsControl.startVpn();
                if (rc == 0) {
                    this.active = true;
                    break block9;
                }
                this.active = false;
                RcsControl.stopDial();
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
            catch (LinkFailedException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
                throw new LinkFailedException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopVpn();
            RcsControl.stopDial();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowDial() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }
}

